<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>
<xsl:stylesheet 
      xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
      version="1.0">
   <xsl:template match="/root">
       <html>
         <head>
		 <META http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
         <style type="text/css">
           body {  font-family: Verdana, Arial, Helvetica, sans-serif}
           h1 {  font-size: 12pt; font-weight: bold; font-style: normal}
           th {  font-size: 8pt; font-weight: bold; text-decoration: underline}
           td {  font-size: 8pt; font-family: Verdana, Arial, Helvetica, sans-serif }
         </style>
           <title><xsl:value-of select="/root/header/@title"/></title>
         </head>
         <body>
			<h1><xsl:value-of select="/root/header/@title"/></h1>
            <xsl:text>&#13;</xsl:text>
            <table border="1" cellSpacing="0" cellPadding="4">
              <xsl:text>&#13;</xsl:text>
              <tr>
				<th><xsl:value-of select="/root/header/@name"/></th>
                <xsl:apply-templates select="/root/header/column"/>
              </tr>
              <xsl:apply-templates select="/root/subject"/>
            </table>
         </body>
       </html>
   </xsl:template>
   <xsl:template match="column">
                <xsl:text>&#13;</xsl:text>
				<th>
                  <xsl:value-of select="@id"/>
                </th>
   </xsl:template>
   <xsl:template match="subject">
       <xsl:text>&#13;</xsl:text>
       <tr>
         <xsl:if test="position() mod 2 = 0">
           <xsl:attribute name="bgcolor">#e0e0ff</xsl:attribute>
         </xsl:if>

         <td>
            <xsl:value-of select="@fullName"/>
            <xsl:if test="string-length(@fullName)=0">
              <xsl:text>&nbsp;</xsl:text>
            </xsl:if>
         </td>
         <xsl:apply-templates select="metric"/>
       </tr>
   </xsl:template>
   <xsl:template match="metric">
         <xsl:text>&#13;</xsl:text>
         <td align="right">

            <xsl:if test="string-length(@value)!=0">
              <xsl:if test="@value &lt; @lowerLimit">
                <xsl:attribute name="style">color: blue</xsl:attribute>
              </xsl:if>

              <xsl:if test="@value &gt; @upperLimit and @upperLimit &gt; 0">
                <xsl:attribute name="style">color: red</xsl:attribute>
              </xsl:if>

              <xsl:value-of select="@value"/>
            </xsl:if>

            <xsl:if test="string-length(@value)=0">
              <xsl:text>&nbsp;</xsl:text>
            </xsl:if>
         </td>
   </xsl:template>
</xsl:stylesheet>
